/*
 * This program talks to a Garmin GPS18 USB as a user applicaion in OS X
 * and displays some info.
*/

/*
 *  copyright 2004 Tim Hogard thogard@abnormal.com 
 *
 * Derivitve work of Apple's USBSimpleExample sample program
 * released under Perl's Artistic License, GPL and/or Apples Public
 * Source License Version 2.
 * Use of this code an any way other than testing means your nuts!
 */

/*
 * Copyright (c) 2003 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
*  Copyright 2001-2002 Apple Computer, Inc. All rights reserved.
*
* IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc. (Apple) in 
* consideration of your agreement to the following terms, and your use, installation, 
* modification or redistribution of this Apple software constitutes acceptance of these
* terms.  If you do not agree with these terms, please do not use, install, modify or 
* redistribute this Apple software.
*
* In consideration of your agreement to abide by the following terms, and subject to these 
* terms, Apple grants you a personal, non exclusive license, under Apples copyrights in this 
* original Apple software (the Apple Software), to use, reproduce, modify and redistribute 
* the Apple Software, with or without modifications, in source and/or binary forms; provided 
* that if you redistribute the Apple Software in its entirety and without modifications, you 
* must retain this notice and the following text and disclaimers in all such redistributions 
* of the Apple Software.  Neither the name, trademarks, service marks or logos of Apple 
* Computer, Inc. may be used to endorse or promote products derived from the Apple Software 
* without specific prior written permission from Apple. Except as expressly stated in this 
* notice, no other rights or licenses, express or implied, are granted by Apple herein, 
* including but not limited to any patent rights that may be infringed by your derivative 
* works or by other works in which the Apple Software may be incorporated.
* 
* The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO WARRANTIES, 
* EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-
* INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE 
* SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS. 
*
* IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL 
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS 
* OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, 
* REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND 
* WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR 
* OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/         										
#include <stdio.h>
#include <math.h>

#include <mach/mach.h>

#include <CoreFoundation/CFNumber.h>

#include <IOKit/IOKitLib.h>
#include <IOKit/IOCFPlugIn.h>
#include <IOKit/usb/IOUSBLib.h>

mach_port_t 	masterPort = 0;				// requires <mach/mach.h>
char		outBuf[8096];
char		inBuf[8096];

int get(IOUSBInterfaceInterface **intf,UInt8 pipe);
double fn4(UInt8 *);

double fn8(UInt8 *);
int init_socket();

void
MyCallBackFunction(void *dummy, IOReturn result, void *arg0)
{
//  UInt8	inPipeRef = (UInt32)dummy;
    
    printf("MyCallbackfunction: %d, %d, %d\n", (int)dummy, (int)result, (int)arg0);
    CFRunLoopStop(CFRunLoopGetCurrent());
}


void transferData(IOUSBInterfaceInterface **intf, UInt8 inPipeRef, UInt8 outPipeRef)
{
    IOReturn			err;
    CFRunLoopSourceRef		cfSource;
    int				i;
    
    err = (*intf)->CreateInterfaceAsyncEventSource(intf, &cfSource);
    if (err)
    {
	printf("transferData: unable to create event source, err = %08x\n", err);
	return;
    }
    CFRunLoopAddSource(CFRunLoopGetCurrent(), cfSource, kCFRunLoopDefaultMode);
    for (i=0; i < 12; i++)
		outBuf[i] = 0;//'R';
	outBuf[4] = 0x5;
		
    err = (*intf)->WritePipe(intf, outPipeRef, outBuf, 12);	// tell device to turn on
	
	printf("starting get1\n");
	get(intf,inPipeRef);
	//get(intf,inPipeRef);

	printf("ending get\n");

	
	for (i=0; i < 12; i++)
		outBuf[i] = 0;
	outBuf[0]=0x14; outBuf[4]=0xfe;	// request device capst
	err = (*intf)->WritePipe(intf, outPipeRef, outBuf, 12);	// tell device to turn on
	get(intf,inPipeRef);
	get(intf,inPipeRef);
	
	for (i=0; i < 16; i++)
		outBuf[i] = 0;
	outBuf[0]=0x14;
	outBuf[4]=0xa; outBuf[8]=4; outBuf[12]=49;	// pvt data start
	err = (*intf)->WritePipe(intf, outPipeRef, outBuf, 16);	// tell device to turn on

	printf("starting get 2\n");
	while(1) get(intf,inPipeRef);
	printf("ending get\n");
//	while(1)
//		get(intf,inPipeRef);
	
    //err = (*intf)->WritePipeAsync(intf, outPipeRef, outBuf, 12, (IOAsyncCallback1)MyCallBackFunction, (void*)(UInt32)inPipeRef);
    /*
	if (err)
    {
	printf("transferData: WritePipeAsyncFailed, err = %08x\n", err);
	CFRunLoopRemoveSource(CFRunLoopGetCurrent(), cfSource, kCFRunLoopDefaultMode);
	return;
    }
    printf("transferData: calling CFRunLoopRun\n");
    CFRunLoopRun();
    printf("transferData: returned from  CFRunLoopRun\n");
    CFRunLoopRemoveSource(CFRunLoopGetCurrent(), cfSource, kCFRunLoopDefaultMode);
	 */
}


void dealWithPipes(IOUSBInterfaceInterface **intf, UInt8 numPipes)
{
    int					i;
    IOReturn				err;			
    UInt8				inPipeRef = 0;
    UInt8				outPipeRef = 0;
    UInt8				direction, number, transferType, interval;
    UInt16				maxPacketSize;
    
    // pipes are one based, since zero is the default control pipe
    for (i=1; i <= numPipes; i++)
    {
	err = (*intf)->GetPipeProperties(intf, i, &direction, &number, &transferType, &maxPacketSize, &interval);
	if (err)
	{
	    printf("dealWithPipes: unable to get pipe properties for pipe %d, err = %08x\n", i, err);
	    return;
	}
	if(transferType== kUSBInterrupt) {
		printf("dealWithPiper: found Interrupt handle\n");
		//irqPipeRef = i;
	} else if (transferType != kUSBBulk)
	{
	    printf("dealWithPipes: skipping pipe %d because it is not a bulk pipe\n", i);
	    continue;
	}
	if ((direction == kUSBIn) && !inPipeRef)
	{
	    printf("dealWithPipes: grabbing BULK IN pipe index %d, number %d\n",i, number);
	    inPipeRef = i;
	}
	if ((direction == kUSBOut) && !outPipeRef)
	{
	    printf("dealWithPipes: grabbing BULK OUT pipe index %d, number %d\n", i, number);
	    outPipeRef = i;
	}
    }
    if (inPipeRef && outPipeRef)
		transferData(intf, inPipeRef, outPipeRef);
}

void dealWithInterface(io_service_t usbInterfaceRef)
{
    IOReturn				err;
    IOCFPlugInInterface 		**iodev;		// requires <IOKit/IOCFPlugIn.h>
    IOUSBInterfaceInterface 		**intf;
    SInt32 				score;
    UInt8				numPipes;


    err = IOCreatePlugInInterfaceForService(usbInterfaceRef, kIOUSBInterfaceUserClientTypeID, kIOCFPlugInInterfaceID, &iodev, &score);
    if (err || !iodev)
    {
	printf("dealWithInterface: unable to create plugin. ret = %08x, iodev = %p\n", err, iodev);
	return;
    }
    err = (*iodev)->QueryInterface(iodev, CFUUIDGetUUIDBytes(kIOUSBInterfaceInterfaceID), (LPVOID)&intf);
    (*iodev)->Release(iodev);				// done with this
    if (err || !intf)
    {
	printf("dealWithInterface: unable to create a device interface. ret = %08x, intf = %p\n", err, intf);
	return;
    }
    err = (*intf)->USBInterfaceOpen(intf);
    if (err)
    {
	printf("dealWithInterface: unable to open interface. ret = %08x\n", err);
	return;
    }
    err = (*intf)->GetNumEndpoints(intf, &numPipes);
    if (err)
    {
	printf("dealWithInterface: unable to get number of endpoints. ret = %08x\n", err);
	(*intf)->USBInterfaceClose(intf);
	(*intf)->Release(intf);
	return;
    }
    
    printf("dealWithInterface: found %d pipes\n", numPipes);
    if (numPipes == 0)
    {
	// try alternate setting 1
	err = (*intf)->SetAlternateInterface(intf, 1);
	if (err)
	{
	    printf("dealWithInterface: unable to set alternate interface 1. ret = %08x\n", err);
	    (*intf)->USBInterfaceClose(intf);
	    (*intf)->Release(intf);
	    return;
	}
	err = (*intf)->GetNumEndpoints(intf, &numPipes);
	if (err)
	{
	    printf("dealWithInterface: unable to get number of endpoints - alt setting 1. ret = %08x\n", err);
	    (*intf)->USBInterfaceClose(intf);
	    (*intf)->Release(intf);
	    return;
	}
	numPipes = 13;  		// workaround. GetNumEndpoints does not work after SetAlternateInterface
    }
    
    if (numPipes)
	dealWithPipes(intf, numPipes);
	
    err = (*intf)->USBInterfaceClose(intf);
    if (err)
    {
	printf("dealWithInterface: unable to close interface. ret = %08x\n", err);
	return;
    }
    err = (*intf)->Release(intf);
    if (err)
    {
	printf("dealWithInterface: unable to release interface. ret = %08x\n", err);
	return;
    }
}


void dealWithDevice(io_service_t usbDeviceRef)
{
    IOReturn				err;
    IOCFPlugInInterface 		**iodev;		// requires <IOKit/IOCFPlugIn.h>
    IOUSBDeviceInterface 		**dev;
    SInt32 				score;
    UInt8				numConf;
    IOUSBConfigurationDescriptorPtr	confDesc;
    IOUSBFindInterfaceRequest		interfaceRequest;
    io_iterator_t			iterator;
    io_service_t			usbInterfaceRef;
    
    err = IOCreatePlugInInterfaceForService(usbDeviceRef, kIOUSBDeviceUserClientTypeID, kIOCFPlugInInterfaceID, &iodev, &score);
    if (err || !iodev)
    {
	printf("dealWithDevice: unable to create plugin. ret = %08x, iodev = %p\n", err, iodev);
	return;
    }
    err = (*iodev)->QueryInterface(iodev, CFUUIDGetUUIDBytes(kIOUSBDeviceInterfaceID), (LPVOID)&dev);
    (*iodev)->Release(iodev);				// done with this
    if (err || !dev)
    {
	printf("dealWithDevice: unable to create a device interface. ret = %08x, dev = %p\n", err, dev);
	return;
    }
    err = (*dev)->USBDeviceOpen(dev);
    if (err)
    {
	printf("dealWithDevice: unable to open device. ret = %08x\n", err);
	return;
    }
    err = (*dev)->GetNumberOfConfigurations(dev, &numConf);
    if (err || !numConf)
    {
	printf("dealWithDevice: unable to obtain the number of configurations. ret = %08x\n", err);
        (*dev)->USBDeviceClose(dev);
        (*dev)->Release(dev);
	return;
    }
    printf("dealWithDevice: found %d configurations\n", numConf);
    err = (*dev)->GetConfigurationDescriptorPtr(dev, 0, &confDesc);			// get the first config desc (index 0)
    if (err)
    {
	printf("dealWithDevice:unable to get config descriptor for index 0\n");
        (*dev)->USBDeviceClose(dev);
        (*dev)->Release(dev);
	return;
    }
    err = (*dev)->SetConfiguration(dev, confDesc->bConfigurationValue);
    if (err)
    {
	printf("dealWithDevice: unable to set the configuration\n");
        (*dev)->USBDeviceClose(dev);
        (*dev)->Release(dev);
	return;
    }
    
    interfaceRequest.bInterfaceClass = kIOUSBFindInterfaceDontCare;		// requested class
    interfaceRequest.bInterfaceSubClass = kIOUSBFindInterfaceDontCare;		// requested subclass
    interfaceRequest.bInterfaceProtocol = kIOUSBFindInterfaceDontCare;		// requested protocol
    interfaceRequest.bAlternateSetting = kIOUSBFindInterfaceDontCare;		// requested alt setting
    
    err = (*dev)->CreateInterfaceIterator(dev, &interfaceRequest, &iterator);
    if (err)
    {
	printf("dealWithDevice: unable to create interface iterator\n");
        (*dev)->USBDeviceClose(dev);
        (*dev)->Release(dev);
	return;
    }
    
    while ( (usbInterfaceRef = IOIteratorNext(iterator)) )
    {
	printf("found interface: %p\n", (void*)usbInterfaceRef);
	dealWithInterface(usbInterfaceRef);
	IOObjectRelease(usbInterfaceRef);				// no longer need this reference
    }
    
    IOObjectRelease(iterator);
    iterator = 0;

    err = (*dev)->USBDeviceClose(dev);
    if (err)
    {
	printf("dealWithDevice: error closing device - %08x\n", err);
	(*dev)->Release(dev);
	return;
    }
    err = (*dev)->Release(dev);
    if (err)
    {
	printf("dealWithDevice: error releasing device - %08x\n", err);
	return;
    }
}



int main (int argc, const char * argv[])
{
    kern_return_t		err;
    CFMutableDictionaryRef 	matchingDictionary = 0;		// requires <IOKit/IOKitLib.h>
    //SInt32			idVendor = 1351;
    SInt32			idVendor =2334;	// Garmin
    //SInt32			idProduct = 8193;
    SInt32			idProduct = 3;	// All Garmin GPS
    CFNumberRef			numberRef;
    io_iterator_t 		iterator = 0;
    io_service_t		usbDeviceRef;
    
	//init_socket();
    err = IOMasterPort(MACH_PORT_NULL, &masterPort);				
    if (err)
    {
        printf("USBSimpleExample: could not create master port, err = %08x\n", err);
        return err;
    }
    matchingDictionary = IOServiceMatching(kIOUSBDeviceClassName);	// requires <IOKit/usb/IOUSBLib.h>
    if (!matchingDictionary)
    {
        printf("USBSimpleExample: could not create matching dictionary\n");
        return -1;
    }
    numberRef = CFNumberCreate(kCFAllocatorDefault, kCFNumberSInt32Type, &idVendor);
    if (!numberRef)
    {
        printf("USBSimpleExample: could not create CFNumberRef for vendor\n");
        return -1;
    }
    CFDictionaryAddValue(matchingDictionary, CFSTR(kUSBVendorID), numberRef);
    CFRelease(numberRef);
    numberRef = 0;
    numberRef = CFNumberCreate(kCFAllocatorDefault, kCFNumberSInt32Type, &idProduct);
    if (!numberRef)
    {
        printf("USBSimpleExample: could not create CFNumberRef for product\n");
        return -1;
    }
    CFDictionaryAddValue(matchingDictionary, CFSTR(kUSBProductID), numberRef);
    CFRelease(numberRef);
    numberRef = 0;
    
    err = IOServiceGetMatchingServices(masterPort, matchingDictionary, &iterator);
    matchingDictionary = 0;			// this was consumed by the above call
    
    while ( (usbDeviceRef = IOIteratorNext(iterator)) )
    {
	printf("Found device %p\n", (void*)usbDeviceRef);
	dealWithDevice(usbDeviceRef);
	IOObjectRelease(usbDeviceRef);			// no longer need this reference
    }
    
    IOObjectRelease(iterator);
    iterator = 0;
    
    mach_port_deallocate(mach_task_self(), masterPort);
    return 0;
}

// Tims code below

typedef struct {
	float alt,epe,eph,epv;
	short fix;
	double gps_tow,lat,lon;
	float lon_vel,lat_vel,alt_vel,msl_hght;
	short leap_sec;
	long grmn_days;
} cpo_pvt_data;

int get(IOUSBInterfaceInterface **intf,UInt8 pipe) {
	UInt8 buf[8192+2];
	UInt8 *b=&buf[12];  // were data starts
	;
	int *x=(int *)buf;
	double *z=(double *)b;
	int count=200;
	int size;
	IOReturn err;
	int i,t;
	double dx,dy;
	int sats,satsem;
	int hex=1; //print hex dump
	cpo_pvt_data *pvt=(cpo_pvt_data *)b;

	err = (*intf)->ReadPipe(intf, pipe, buf, &count);
	if(err) {
		printf("read3 error?\n");
	} else {
		//printf("read3 was ok %d\n",count);
		//printf("pt=%d pid=%d\n",x[0],x[1]);
		size=buf[8]+buf[9]*256;
		//printf("size=%d pid=%d\n",size,buf[4]);
		switch(buf[4]) {
			case 0xff:
				printf("Type: (%d v%g) %s\n",b[0],b[2]/100.0,&b[4]);
				hex=0;
				break;
			case 0xfd:
				// code fd, device cabibilitys.  A table of 
				while(size>0) {
					//		printf("code %c: %d\n", b[0],b[1]+b[2]*256);
					size-=3;
					b+=3;
				}
				hex=0;
				break;
				
			case 0x11: // pos
				printf("%g %g\n",z[0],z[1]); // opps in intel format....
				break;
			case 0x33: // 51: pvt data unknown
					   // f,f,f,f,i,d,d,d,f,f,f,f,i,l=alt,epe,epeh,epev,fix,time,posx,posy,veast,vnorht,vup,msl,leaps,wn_days
					   // all in intel floating point...
				/*		14 00 00 00 33 00 00 00 40 00 00 00
				81 99 d7 41 08 2b 27 42 49 92 f5 41 eb 6e c4 41 01 00 91 97 e9 ff d7 6a
				05 41 0f 7d 8e c5 f3 1d e5 bf 1d 4b 08 0c a6 3d 04 40 00 00 00 00 00 00
				00 00 00 00 00 00 bc 03 85 3f 0d 00 31 a1 00 00 */
				///printf("\033[H\033[2J");
				//printf("pPOS *********** alt: %g  epe(%g %g %g)\n",fn4(&b[0]),fn4(&b[4]),fn4(&b[8]),fn4(&b[12])); // alt
				printf("alt: %g  epe(%g %g %g)\n",fn4(&pvt->alt),fn4(&pvt->epe),fn4(&pvt->eph),fn4(&pvt->epv)); // alt
				printf("fix %d\n",b[16]+b[17]*256);
				printf("t: %g lat: %10.10g lon: %10.10g\n",fn8(&b[18]),fn8(&b[26])*180/M_PI,fn8(&b[34])*180/M_PI);
				dx=fn4(&b[42])*3.6;
				dy=fn4(&b[46])*3.6;
				//printf("dv: norht%g east%g up%g msl%g\n",dx=fn4(&b[42])*3.6,dy=fn4(&b[46])*3.6,fn4(&b[50]),fn4(&b[54]));
//				float lon_vel,lat_vel,alt_vel,msl_hght;
				printf("speed=%6.4g km/hr\n",sqrt(dx*dx+dy*dy));
				//printf("speed=%6.4g\n",sqrt(fn4(&pvt->lon_vel)*fn4(&pvt->lon_vel)+fn4(&pvt->lat_vel)*fn4(&pvt->lat_vel))*3.6);
				//printf("leapsec: %d days: %d\n",b[58]+b[59]*256,fn4(&b[60]));
				t=b[60]+b[61]*256+b[62]*65536+b[63]*16777216;
				printf("time %d %d\n",t,fn4(&pvt->grmn_days));
				// time is funky time 41265 at Fri Nov 12 01:51:04 EST 2004

				//Its supposed to be days since jan 1 1990
				hex=0;
				break;
			case 0x72:	//  114: sat status
				count=sats=satsem=0;
				while(size>0) {
					//sv#8,signal db16,ele8,azmth16,flags8
					// flags: 1==has emhemerisis, 2==has diff corrections 4==sat is being used
					size-=7;
					//printf("sv%02d%c %f  (%d %d)\n",b[0],b[6]&0x4?'*':' ',(b[1]+b[2]*256)/100.0,b[3],b[4]+b[5]*256);
					//printf("%f ",(b[1]+b[2]*256)/100.0);
					if(b[6])
						sats++;
					if(b[6]&0x4)
					if(b[6]&0x1)
						satsem++;
					b+=7;
				}
					
					printf("tracking %d (%d) of %d sats\n",count,satsem,sats);
				hex=0;
				break;
			case 0xe:	// date and time
				printf("%d/%d %d  %02d:%02d:%02d\n",b[0],b[1],b[2]+b[3]*256,b[4],b[6],b[7]); // why is it 2102AD?
				break;
			default:
				printf("unknown packet ID of %d (%x)\n",x[1],x[1]);
				break;
		}
		//x=&buf[12];
		//printf(" %x %d ",*x,*x);
		if(hex) {
			for(i=0;i<count;i++)
				printf("%02x ",buf[i]);		
			printf("\n");
		}
	}
}

double fn4(UInt8 *x) {
	float z;
	UInt8 *c=(UInt8 *)&z;
	c[0]=x[3];
	c[1]=x[2];
	c[2]=x[1];
	c[3]=x[0];
	return z;
};

double fn8(UInt8 *x) {
	double z;
	UInt8 *c=(UInt8 *)&z;
	c[0]=x[7];
	c[1]=x[6];
	c[2]=x[5];
	c[3]=x[4];
	c[4]=x[3];
	c[5]=x[2];
	c[6]=x[1];
	c[7]=x[0];
	return z;
};

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <unistd.h>

#define SERVER_PORT 2947

int init_socket() { // open tcp socket on port 2947
	
	int sd, newSd, cliLen;
	int opt=1;
	
	struct sockaddr_in cliAddr, servAddr;
	char buf[1024];
	/* create socket */
	sd = socket(AF_INET, SOCK_STREAM, 0);
	if(sd<0) {
		perror("cannot open socket ");
		exit(1);
		return -1;
	}
	
	setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (char *)&opt, sizeof(opt));
	/* bind server port */
	servAddr.sin_family = AF_INET;
	servAddr.sin_addr.s_addr = htonl(INADDR_ANY);
	servAddr.sin_port = htons(SERVER_PORT);
	
	if(bind(sd, (struct sockaddr *) &servAddr, sizeof(servAddr))<0) {
		perror("cannot bind port ");
		exit(1);
		return -1;
	}

	printf("calling listen\n");
	listen(sd,5);
	
	while(1) {
		
		printf(": waiting for data on port TCP %u\n",SERVER_PORT);
		
		cliLen = sizeof(cliAddr);
		newSd = accept(sd, (struct sockaddr *) &cliAddr, &cliLen);
		if(newSd<0) {
			perror("cannot accept connection ");
			return -1;
		} else {
			printf("got line\n");
		}
		
		send(newSd, "Hi\n",3,0);
		//	buf, strlen(buf), 0) == -1);

		/* get a message from the client */
		if (recv(newSd, buf, sizeof(buf), 0) == -1) {
			perror("recv");
			exit(1);
		}
		
        /* get the directory contents */
		//read_dir(dir);
		
		/* strcat (dir," DUDE");
		*/
		/* acknowledge the message, reply w/ the file names */
		if (send(newSd, buf, strlen(buf), 0) == -1) {
			perror("send");
			exit(1);
		}
		
	}
}
